#include <bits/stdc++.h>
#define ll long long

using namespace std;

#define MAXN 200005

int N, M, S, T;
set<int> adj1[MAXN];
set<int> adj2[MAXN];
int dist[MAXN];

int dijkstra(int start, int end)
{
  for (int i = 1; i <= N; i++)
  {
    dist[i] = INT_MAX;
  }

  priority_queue<pair<int, int>, vector<pair<int, int>>, greater<pair<int, int>>> pq;
  pq.push({0, start});
  dist[start] = 0;
  while (!pq.empty())
  {
    int u = pq.top().second;
    pq.pop();
    for (int v : adj2[u])
    {
      if (dist[v] > dist[u] + 1)
      {
        dist[v] = dist[u] + 1;
        pq.push({dist[v], v});
      }
    }
  }
  return dist[end];
}

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  cin >> N >> M >> S >> T;
  for (int i = 0; i < M; i++)
  {
    int a, b;
    cin >> a >> b;
    adj1[a].insert(b);
    adj1[b].insert(a);
  }

  for (int a = 1; a <= N; a++)
  {
    for (int c : adj1[a])
    {
      for (int b : adj1[c])
      {
        adj2[a].insert(b);
      }
    }
  }

  int ans = dijkstra(S, T);
  cout << ans << "\n";
}